/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.m5;

import java.io.Serializable;
import weka.classifiers.trees.m5.SplitEvaluate;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.PairedStats;

public final class CorrelationSplitInfo
implements Cloneable,
Serializable,
SplitEvaluate,
RevisionHandler {
    private static final long serialVersionUID = 4212734895125452770L;
    private int m_first;
    private int m_last;
    private int m_position;
    private double m_maxImpurity;
    private int m_splitAttr;
    private double m_splitValue;
    private int m_number;

    public CorrelationSplitInfo(int low, int high, int attr) {
        this.initialize(low, high, attr);
    }

    @Override
    public final SplitEvaluate copy() throws Exception {
        CorrelationSplitInfo s = (CorrelationSplitInfo)this.clone();
        return s;
    }

    public final void initialize(int low, int high, int attr) {
        this.m_number = high - low + 1;
        this.m_first = low;
        this.m_last = high;
        this.m_position = -1;
        this.m_maxImpurity = -1.7976931348623157E308;
        this.m_splitAttr = attr;
        this.m_splitValue = 0.0;
    }

    @Override
    public final void attrSplit(int attr, Instances inst) throws Exception {
        int low = 0;
        int high = inst.numInstances() - 1;
        PairedStats full = new PairedStats(0.01);
        PairedStats leftSubset = new PairedStats(0.01);
        PairedStats rightSubset = new PairedStats(0.01);
        int classIndex = inst.classIndex();
        double order = 2.0;
        this.initialize(low, high, attr);
        if (this.m_number < 4) {
            return;
        }
        int len = high - low + 1 < 5 ? 1 : (high - low + 1) / 5;
        this.m_position = low;
        int part = low + len - 1;
        int i = low;
        while (i < len) {
            full.add(inst.instance(i).value(attr), inst.instance(i).value(classIndex));
            leftSubset.add(inst.instance(i).value(attr), inst.instance(i).value(classIndex));
            ++i;
        }
        i = len;
        while (i < inst.numInstances()) {
            full.add(inst.instance(i).value(attr), inst.instance(i).value(classIndex));
            rightSubset.add(inst.instance(i).value(attr), inst.instance(i).value(classIndex));
            ++i;
        }
        full.calculateDerived();
        double allVar = full.yStats.stdDev * full.yStats.stdDev;
        allVar = Math.abs(allVar);
        allVar = Math.pow(allVar, 1.0 / order);
        i = low + len;
        while (i < high - len - 1) {
            rightSubset.subtract(inst.instance(i).value(attr), inst.instance(i).value(classIndex));
            leftSubset.add(inst.instance(i).value(attr), inst.instance(i).value(classIndex));
            if (!Utils.eq(inst.instance(i + 1).value(attr), inst.instance(i).value(attr))) {
                leftSubset.calculateDerived();
                rightSubset.calculateDerived();
                double leftCorr = Math.abs(leftSubset.correlation);
                double rightCorr = Math.abs(rightSubset.correlation);
                double leftVar = leftSubset.yStats.stdDev * leftSubset.yStats.stdDev;
                leftVar = Math.abs(leftVar);
                leftVar = Math.pow(leftVar, 1.0 / order);
                double rightVar = rightSubset.yStats.stdDev * rightSubset.yStats.stdDev;
                rightVar = Math.abs(rightVar);
                rightVar = Math.pow(rightVar, 1.0 / order);
                double score = allVar - leftSubset.count / full.count * leftVar - rightSubset.count / full.count * rightVar;
                leftCorr = leftSubset.count / full.count * leftCorr;
                rightCorr = rightSubset.count / full.count * rightCorr;
                double c_score = leftCorr + rightCorr - Math.abs(full.correlation);
                if (!Utils.eq(score, 0.0) && score > this.m_maxImpurity) {
                    this.m_maxImpurity = score;
                    this.m_splitValue = (inst.instance(i).value(attr) + inst.instance(i + 1).value(attr)) * 0.5;
                    this.m_position = i;
                }
            }
            ++i;
        }
    }

    @Override
    public double maxImpurity() {
        return this.m_maxImpurity;
    }

    @Override
    public int splitAttr() {
        return this.m_splitAttr;
    }

    @Override
    public int position() {
        return this.m_position;
    }

    @Override
    public double splitValue() {
        return this.m_splitValue;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

